IF OBJECT_ID('V_GWEB_SCRIPTS_TOTAL_PENDENTES') IS NOT NULL
	DROP VIEW V_GWEB_SCRIPTS_TOTAL_PENDENTES
	
GO

CREATE VIEW V_GWEB_SCRIPTS_TOTAL_PENDENTES AS
	SELECT SUM(RS.SQLSERVER) AS SQLSERVER, SUM(RS.POSTGRESQL) AS POSTGRESQL
	FROM (
		SELECT COUNT(*) AS SQLSERVER , 0 AS POSTGRESQL
		FROM DSYNC_CH_SCRIPTS SC
		LEFT JOIN DSYNC_CH_SCRIPTS_STATUS SS
			ON SS.CRC_FILE = SC.CRC_FILE
		WHERE (SS.STS_SCRIPT = 2
			OR SS.STS_SCRIPT IS NULL)
			AND SC.DB_ID IN (1,2,3)
	UNION
		SELECT 0 AS SQLSERVER, COUNT(*) AS POSTGRESQL
		FROM DSYNC_CLIENT DS
		LEFT JOIN DSYNC_CH_SCRIPTS SC
			ON SC.DB_ID IN (4,5)
		LEFT JOIN DSYNC_CH_SCRIPTS_STATUS SS
			ON SS.CRC_FILE = SC.CRC_FILE
			AND SS.CD_FILIAL = DS.CID
		WHERE (SS.STS_SCRIPT <> 1
			OR SS.STS_SCRIPT IS NULL)
			AND SC.CRC_FILE IS NOT NULL
			AND DS.ATIVO = 1
	) AS RS